/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools.modifiers.ability.armor;

import io.github.fabricators_of_create.porting_lib.attributes.PortingLibAttributes;
import io.github.fabricators_of_create.porting_lib.entity.events.LivingEntityEvents;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.common.Sounds;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.helper.ModifierUtil;
import slimeknights.tconstruct.library.utils.SlimeBounceHandler;

public class BouncyModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BOUNCY = TConstruct.createKey("bouncy");

    public BouncyModifier() {
        super(BOUNCY, true);
        LivingEntityEvents.FALL.register(BouncyModifier::onFall);
    }

    private static void onFall(LivingEntityEvents.Fall.FallEvent event) {
        class_1309 living = (class_1309)event.getEntity();
        if (living == null || living.method_18798().field_1351 > -0.3 && living.field_6017 < 3.0f) {
            return;
        }
        if (ModifierUtil.getTotalModifierLevel(living, BOUNCY) == 0) {
            return;
        }
        if (living.method_21750()) {
            event.setDamageMultiplier(0.5f);
            return;
        }
        event.setDamageMultiplier(0.0f);
        class_243 motion = living.method_18798();
        if (living instanceof class_3222) {
            double gravity = living.method_26825(PortingLibAttributes.ENTITY_GRAVITY);
            double time = Math.sqrt((double)living.field_6017 / gravity);
            double velocity = gravity * time;
            living.method_18800(motion.field_1352 / (double)0.975f, velocity, motion.field_1350 / (double)0.975f);
            living.field_6037 = true;
            SlimeBounceHandler.addBounceHandler(living);
        } else {
            float factor = living.field_6017 < 2.0f ? -0.7f : -0.9f;
            living.method_18800(motion.field_1352 / (double)0.975f, motion.field_1351 * (double)factor, motion.field_1350 / (double)0.975f);
            SlimeBounceHandler.addBounceHandler(living, living.method_18798());
        }
        event.setDistance(0.0f);
        if (!living.method_37908().field_9236) {
            living.field_6007 = true;
            event.setCanceled(true);
            living.method_24830(false);
        }
        living.method_5783(Sounds.SLIMY_BOUNCE.getSound(), 1.0f, 1.0f);
    }
}

